<?php
/**
 * GeoDirectory BlockStrap Features
 *
 * @author   AyeCode
 * @category Full Site Editing
 * @package  GeoDirectory
 * @since    2.0.x
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class GeoDir_BlockStrap {


	public static function init() {
		add_filter( 'blockstrap_pattern_page_content_gd_archive_default', array( __CLASS__, 'archive_template' ), 10, 1 );
		add_filter( 'blockstrap_pattern_page_content_gd_search_default', array( __CLASS__, 'search_template' ), 10, 1 );
		add_filter( 'blockstrap_pattern_page_content_gd_single_default', array( __CLASS__, 'single_template' ), 10, 1 );
		add_filter( 'blockstrap_pattern_page_content_gd_add_listing_default', array( __CLASS__, 'add_listing_template' ), 10, 1 );
		add_filter( 'blockstrap_pattern_page_content_gd_location_default', array( __CLASS__, 'location_template' ), 10, 1 );

	}

	/**
	 * Add content to the GD location page template of the BLockStrap theme.
	 *
	 * @param $content
	 *
	 * @return string
	 */
	public static function location_template( $content ) {
		ob_start();
		?>
		<!-- wp:blockstrap/blockstrap-widget-container {"container":"container-fluid","bg":"custom-gradient","bg_gradient":"linear-gradient(135deg,rgb(2,11,185) 2%,rgb(126,5,170) 100%)","mb_lg":"6","position":"position-relative","sd_shortcode":"[bs_container container='container-fluid'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg='custom-gradient'  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgb(2,11,185) 2%,rgb(126,5,170) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='6'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position='position-relative'  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container mb-6 bg-custom-gradient bg-image-fixed container-fluid position-relative" style="background-image:linear-gradient(135deg,rgb(2,11,185) 2%,rgb(126,5,170) 100%)"><!-- wp:blockstrap/blockstrap-widget-shape-divider {"sd":"curve","sd_position":"bottom","sd_color":"white","sd_width":"140","sd_invert":true,"styleid":"block-xu9bmn6lkf","sd_shortcode":"[bs_shape_divider sd='curve'  sd_position='bottom'  sd_color='white'  sd_custom_color='#0073aa'  sd_width='140'  sd_height='100'  sd_flip='false'  sd_invert='true'  sd_btf='false'  styleid='block-xu9bmn6lkf' ]"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-shape-divider block-xu9bmn6lkf blockstrap-shape blockstrap-shape-bottom position-absolute"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="bg-white blockstrap-shape-fill" d="M500,97C126.7,96.3,0.8,19.8,0,0v100l1000,0V1C1000,19.4,873.3,97.8,500,97z"/></svg></div><style>.block-xu9bmn6lkf { pointer-events: none;background-repeat: no-repeat;bottom:  -1px; left: -1px;right: -1px;line-height: 0;overflow: hidden;margin: 0 1px;}.block-xu9bmn6lkf svg{ height: 100px;width: calc(140% + 1.3px);left: 50%;position: relative;display: block;-webkit-transform: translateX(-50%); -ms-transform: translateX(-50%); transform: translateX(-50%);}.block-xu9bmn6lkf svg path{ }</style>
			<!-- /wp:blockstrap/blockstrap-widget-shape-divider -->

			<!-- wp:blockstrap/blockstrap-widget-container {"mt_lg":"0","pt_lg":"5","pb_lg":"2","sd_shortcode":"[bs_container container='container'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg='0'  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg='2'  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mt-0 mb-3 pt-5 pb-2 bg-image-fixed container"><!-- wp:blockstrap/blockstrap-widget-container {"container":"row","sd_shortcode":"[bs_container container='row'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
				<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 bg-image-fixed row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","text_align_lg":"text-lg-center","mt_lg":"5","mb_lg":"5","pt_lg":"5","pb_lg":"5","sd_shortcode":"[bs_container container='col'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg='text-lg-center'  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg='5'  mr_lg=''  mb_lg='5'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg='5'  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
					<div class="wp-block-blockstrap-blockstrap-widget-container mt-5 mb-5 pt-5 pb-5 bg-image-fixed text-center col"><!-- wp:blockstrap/blockstrap-widget-heading {"text":"Explore [gd_location_meta no_wrap='true']","text_color":"light"} -->
						<h1 class="wp-block-blockstrap-blockstrap-widget-heading mb-3 text-light">Explore [gd_location_meta no_wrap='true']</h1>
						<!-- /wp:blockstrap/blockstrap-widget-heading --></div>
					<!-- /wp:blockstrap/blockstrap-widget-container --></div>
				<!-- /wp:blockstrap/blockstrap-widget-container --></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container -->

		<!-- wp:blockstrap/blockstrap-widget-container {"sd_shortcode":"[bs_container container='container'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 bg-image-fixed container"><!-- wp:blockstrap/blockstrap-widget-container {"container":"row","sd_shortcode":"[bs_container container='row'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 bg-image-fixed row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","sd_shortcode":"[bs_container container='col'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
				<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 bg-image-fixed col"><!-- wp:geodirectory/geodir-widget-categories {"content": "","sd_shortcode":"[gd_categories title=''  widget_title_tag=''  widget_title_size_class=''  widget_title_align_class=''  widget_title_color_class=''  widget_title_border_class=''  widget_title_border_color_class=''  widget_title_mt_class=''  widget_title_mr_class=''  widget_title_mb_class=''  widget_title_ml_class=''  widget_title_pt_class=''  widget_title_pr_class=''  widget_title_pb_class=''  widget_title_pl_class=''  post_type='0'  cpt_ajax='false'  filter_ids=''  hide_empty='false'  max_level='1'  max_count='all'  max_count_child='all'  no_cpt_filter='false'  no_cat_filter='false'  sort_by='count'  design_type=''  row_items=''  row_positioning=''  card_padding_inside=''  card_color=''  card_shadow=''  hide_icon='false'  use_image='false'  image_size='medium'  icon_color=''  icon_size=''  cat_text_color=''  cat_text_color_custom=''  cat_font_size=''  cat_font_size_custom=''  cat_font_weight=''  cat_font_case=''  hide_count='false'  badge_position=''  badge_color='light'  badge_text_append='light'  badge_text_color=''  badge_text_color_custom=''  badge_font_size=''  badge_font_size_custom=''  badge_font_weight=''  badge_font_case=''  cpt_title='false'  title_tag='h4'  bg=''  mt=''  mr=''  mb='3'  ml=''  pt=''  pr=''  pb=''  pl=''  border=''  rounded=''  rounded_size=''  shadow=''  css_class='' ]"} -->
					<div class="wp-block-geodirectory-geodir-widget-categories"></div>
					<!-- /wp:geodirectory/geodir-widget-categories --></div>
				<!-- /wp:blockstrap/blockstrap-widget-container --></div>
			<!-- /wp:blockstrap/blockstrap-widget-container -->

			<!-- wp:blockstrap/blockstrap-widget-container {"container":"row","mb_lg":"5","sd_shortcode":"[bs_container container='row'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='5'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mb-5 bg-image-fixed row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","sd_shortcode":"[bs_container container='col'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
				<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 bg-image-fixed col"><!-- wp:geodirectory/geodir-widget-map {"show_advanced":true,"map_type":"directory","search_filter":true,"post_type_filter":true,"cat_filter":true,"child_collapse":true,"content":"\u003cdiv class=\u0022geodir-wgt-map bsui sdel-f214d462\u0022 \u003e\u003cdiv class=\u0022bsui\u0022 style=\u0022overflow:hidden;height:425px\u0022 class=\u0022wp-block-geodirectory-geodir-widget-map\u0022\u003e\u003cdiv title=\u0022Placeholder map\u0022 style=\u0022height:425px;width:100%;background-size:cover;background-image:url(data:image/svg+xml;base64,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)\u0022 class=\u0022100 425px\u0022\u003e\u003c/div\u003e\u003c/div\u003e\u003c/div\u003e","sd_shortcode":"[gd_map title=''  map_type='directory'  post_settings='true'  post_type=''  terms=''  tick_terms=''  tags=''  all_posts='false'  post_id=''  search_filter='true'  post_type_filter='true'  cat_filter='true'  child_collapse='true'  map_directions='false'  scrollwheel='false'  hide_zoom_control='false'  hide_street_control='false'  sticky='false'  static='false'  width='100%'  height='425px'  maptype='ROADMAP'  zoom='0'  bg=''  mt=''  mr=''  mb=''  ml=''  pt=''  pr=''  pb=''  pl=''  border=''  rounded=''  rounded_size=''  shadow=''  css_class='' ]"} -->
					<div class="wp-block-geodirectory-geodir-widget-map"></div>
					<!-- /wp:geodirectory/geodir-widget-map --></div>
				<!-- /wp:blockstrap/blockstrap-widget-container --></div>
			<!-- /wp:blockstrap/blockstrap-widget-container -->

			<!-- wp:blockstrap/blockstrap-widget-container {"container":"row","sd_shortcode":"[bs_container container='row'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 bg-image-fixed row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","sd_shortcode":"[bs_container container='col'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
				<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 bg-image-fixed col"><!-- wp:blockstrap/blockstrap-widget-heading {"text":"Top rated listings","html_tag":"h2","mb_lg":"4"} -->
					<h2 class="wp-block-blockstrap-blockstrap-widget-heading mb-4">Top rated listings</h2>
					<!-- /wp:blockstrap/blockstrap-widget-heading -->

					<!-- wp:geodirectory/geodir-widget-listings {"post_limit":6,"sort_by":"high_rating","layout":"3","template_type":"template_part","tmpl_part":"gd-archive-item","content": "","sd_shortcode":"[gd_listings title=''  widget_title_tag=''  widget_title_size_class=''  widget_title_align_class=''  widget_title_color_class=''  widget_title_border_class=''  widget_title_border_color_class=''  widget_title_mt_class=''  widget_title_mr_class=''  widget_title_mb_class=''  widget_title_ml_class=''  widget_title_pt_class=''  widget_title_pr_class=''  widget_title_pb_class=''  widget_title_pl_class=''  hide_if_empty='false'  post_type='gd_place'  category=''  related_to=''  tags=''  post_author=''  post_limit='6'  post_ids=''  add_location_filter='true'  nearby_gps='false'  show_featured_only='false'  show_special_only='false'  with_pics_only='false'  with_videos_only='false'  show_favorites_only='false'  favorites_by_user=''  use_viewing_post_type='false'  use_viewing_term='false'  sort_by='high_rating'  title_tag='h3'  layout='3'  view_all_link='true'  with_pagination='false'  top_pagination='false'  bottom_pagination='true'  pagination_info=''  template_type='template_part'  tmpl_page=''  tmpl_part='gd-archive-item'  row_gap=''  column_gap=''  card_border=''  card_shadow=''  with_carousel=''  with_indicators=''  indicators_mb=''  with_controls=''  slide_interval='5'  slide_ride=''  center_slide=''  bg=''  mt=''  mr=''  mb='3'  ml=''  pt=''  pr=''  pb=''  pl=''  border=''  rounded=''  rounded_size=''  shadow=''  css_class='' ]"} -->
					<div class="wp-block-geodirectory-geodir-widget-listings"></div>
					<!-- /wp:geodirectory/geodir-widget-listings --></div>
				<!-- /wp:blockstrap/blockstrap-widget-container --></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container -->

		<?php
		return ob_get_clean();
	}

	/**
	 * Add content to the GD single page template of the BLockStrap theme.
	 *
	 * @param $content
	 *
	 * @return string
	 */
	public static function add_listing_template( $content ) {
		ob_start();
		?>
		<!-- wp:blockstrap/blockstrap-widget-container {"container":"container-fluid","bg":"custom-gradient","bg_gradient":"linear-gradient(135deg,rgb(2,11,185) 2%,rgb(126,5,170) 100%)","position":"position-relative","sd_shortcode":"[bs_container container='container-fluid'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg='custom-gradient'  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgb(2,11,185) 2%,rgb(126,5,170) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position='position-relative'  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 bg-custom-gradient bg-image-fixed container-fluid position-relative" style="background-image:linear-gradient(135deg,rgb(2,11,185) 2%,rgb(126,5,170) 100%)"><!-- wp:blockstrap/blockstrap-widget-shape-divider {"sd":"curve","sd_position":"bottom","sd_color":"white","sd_width":"140","sd_invert":true,"styleid":"block-xu9bmn6lkf","sd_shortcode":"[bs_shape_divider sd='curve'  sd_position='bottom'  sd_color='white'  sd_custom_color='#0073aa'  sd_width='140'  sd_height='100'  sd_flip='false'  sd_invert='true'  sd_btf='false'  styleid='block-xu9bmn6lkf' ]"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-shape-divider block-xu9bmn6lkf blockstrap-shape blockstrap-shape-bottom position-absolute"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="bg-white blockstrap-shape-fill" d="M500,97C126.7,96.3,0.8,19.8,0,0v100l1000,0V1C1000,19.4,873.3,97.8,500,97z"/></svg></div><style>.block-xu9bmn6lkf { pointer-events: none;background-repeat: no-repeat;bottom:  -1px; left: -1px;right: -1px;line-height: 0;overflow: hidden;margin: 0 1px;}.block-xu9bmn6lkf svg{ height: 100px;width: calc(140% + 1.3px);left: 50%;position: relative;display: block;-webkit-transform: translateX(-50%); -ms-transform: translateX(-50%); transform: translateX(-50%);}.block-xu9bmn6lkf svg path{ }</style>
			<!-- /wp:blockstrap/blockstrap-widget-shape-divider -->

			<!-- wp:blockstrap/blockstrap-widget-container {"mt_lg":"0","pt_lg":"5","pb_lg":"2","sd_shortcode":"[bs_container container='container'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg='0'  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg='2'  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mt-0 mb-3 pt-5 pb-2 bg-image-fixed container"><!-- wp:blockstrap/blockstrap-widget-container {"container":"row","sd_shortcode":"[bs_container container='row'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
				<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 bg-image-fixed row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","text_align_lg":"text-lg-center","mt_lg":"5","mb_lg":"5","pt_lg":"5","pb_lg":"5","sd_shortcode":"[bs_container container='col'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg='text-lg-center'  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg='5'  mr_lg=''  mb_lg='5'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg='5'  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
					<div class="wp-block-blockstrap-blockstrap-widget-container mt-5 mb-5 pt-5 pb-5 bg-image-fixed text-center col"><!-- wp:blockstrap/blockstrap-widget-post-title {"text_color":"white","sd_shortcode":"[bs_post_title html_tag='h1'  is_link='false'  stretched_link='false'  text_color='white'  text_color_custom=''  font_size=''  font_size_custom=''  font_line_height=''  font_weight=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_on_text='false'  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  css_class='' ]"} /--></div>
					<!-- /wp:blockstrap/blockstrap-widget-container --></div>
				<!-- /wp:blockstrap/blockstrap-widget-container --></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container -->

		<!-- wp:blockstrap/blockstrap-widget-container {"pt_lg":"5","sd_shortcode":"[bs_container container='container'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 pt-5 bg-image-fixed container"><!-- wp:geodirectory/geodir-widget-add-listing {"content":"\u003cdiv class=\u0022geodir-add-listing bsui sdel-52263a43\u0022 \u003e\u003cdiv class=\u0022mb-3\u0022\u003e\u003cdiv class=\u0022alert alert-info \u0022 role=\u0022alert\u0022 \u003e\u003ci class=\u0022fas fa-info-circle\u0022\u003e\u003c/i\u003e This is a simple preview for the add listing form.\u003c/div\u003e\u003cdiv class=\u0022mb-3 row\u0022  \u003e\u003clabel  class=\u0022  col-sm-2 col-form-label text form-label\u0022 \u003eTitle\u003c/label\u003e\u003cdiv class=\u0022col-sm-10\u0022  \u003e\u003cinput type=\u0022text\u0022  name=\u0022demo-title\u0022  placeholder=\u0022Enter the listing title\u0022  value=\u0022Example title\u0022  class=\u0022form-control \u0022  \u003e\u003csmall class=\u0022form-text text-muted d-block\u0022\u003eEnter the title for the listing.\u003c/small\u003e\u003c/div\u003e\u003c/div\u003e\u003cdiv class=\u0022mb-3 row\u0022  \u003e\u003clabel  class=\u0022  col-sm-2 col-form-label  form-label\u0022 \u003eDescription\u003c/label\u003e\u003cdiv class=\u0022col-sm-10\u0022\u003e\u003ctextarea  name=\u0022demo-description\u0022  placeholder=\u0022Description text\u0022  rows=\u00228\u0022  class=\u0022form-control \u0022  \u003e\u003c/textarea\u003e\u003csmall class=\u0022form-text text-muted d-block\u0022\u003eEnter a description for your listing.\u003c/small\u003e\u003c/div\u003e\u003c/div\u003e\u003c/div\u003e\u003c/div\u003e","sd_shortcode":"[gd_add_listing post_type=''  show_login='true'  login_msg=''  container=''  mapzoom='0'  label_type=''  bg=''  mt=''  mr=''  mb='3'  ml=''  pt=''  pr=''  pb=''  pl=''  border=''  rounded=''  rounded_size=''  shadow='' ]"} -->
			<div class="wp-block-geodirectory-geodir-widget-add-listing"></div>
			<!-- /wp:geodirectory/geodir-widget-add-listing --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container -->

		<?php
		return ob_get_clean();
	}

	/**
	 * Add content to the GD single page template of the BLockStrap theme.
	 *
	 * @param $content
	 *
	 * @return string
	 */
	public static function single_template( $content ) {
		ob_start();
		?>
		<!-- wp:blockstrap/blockstrap-widget-container {"container":"container-fluid","bg":"custom-color","bg_color":"rgba(0,0,0,0.53)","bg_gradient":"linear-gradient(135deg,rgb(7,101,155) 1%,rgba(155,81,224,0.49) 100%)","bg_image_use_featured":true,"bg_image_xy":{"x":0.5,"y":0.48},"text_color":"white","text_align_lg":"text-lg-center","pt_lg":"5","pb_lg":"5","position":"position-relative","sd_shortcode":"[bs_container container='container-fluid'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg='custom-color'  bg_color='rgba(0,0,0,0.53)'  bg_gradient='linear-gradient(135deg,rgb(7,101,155) 1%,rgba(155,81,224,0.49) 100%)'  bg_image_fixed='false'  bg_image_use_featured='true'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color='white'  text_justify='false'  text_align=''  text_align_md=''  text_align_lg='text-lg-center'  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg='5'  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position='position-relative'  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 pt-5 pb-5 bg-custom-color bg-image-fixed text-white text-center container-fluid position-relative" style="background-color:rgba(0,0,0,0.53);background-image:url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiID8+CjxzdmcgYmFzZVByb2ZpbGU9InRpbnkiIGhlaWdodD0iNDAwIiB2ZXJzaW9uPSIxLjIiIHdpZHRoPSI0MDAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6ZXY9Imh0dHA6Ly93d3cudzMub3JnLzIwMDEveG1sLWV2ZW50cyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPjxkZWZzIC8+PHJlY3QgZmlsbD0iI2QzZDNkMyIgaGVpZ2h0PSI0MDAiIHdpZHRoPSI0MDAiIHg9IjAiIHk9IjAiIC8+PGxpbmUgc3Ryb2tlPSJ3aGl0ZSIgc3Ryb2tlLXdpZHRoPSIxMCIgeDE9IjAiIHgyPSI0MDAiIHkxPSIwIiB5Mj0iNDAwIiAvPjxsaW5lIHN0cm9rZT0id2hpdGUiIHN0cm9rZS13aWR0aD0iMTAiIHgxPSIwIiB4Mj0iNDAwIiB5MT0iNDAwIiB5Mj0iMCIgLz48cmVjdCBmaWxsPSIjZDNkM2QzIiBoZWlnaHQ9IjUwIiB3aWR0aD0iMjE4LjAiIHg9IjkxLjAiIHk9IjE3NS4wIiAvPjx0ZXh0IGZpbGw9IndoaXRlIiBmb250LXNpemU9IjMwIiBmb250LXdlaWdodD0iYm9sZCIgdGV4dC1hbmNob3I9Im1pZGRsZSIgeD0iMjAwLjAiIHk9IjIwNy41Ij5QTEFDRUhPTERFUjwvdGV4dD48L3N2Zz4=);background-blend-mode:overlay;background-size:cover;background-position:50% 48%"><!-- wp:blockstrap/blockstrap-widget-container {"container":"row","bg_image_xy":{"x":0.47,"y":0.45},"pt_lg":"5","pb_lg":"5","sd_shortcode":"[bs_container container='row'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg='5'  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 pt-5 pb-5 bg-image-fixed row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","pt_lg":"5","pb_lg":"5","sd_shortcode":"[bs_container container='col'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg='5'  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
				<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 pt-5 pb-5 bg-image-fixed col"><!-- wp:blockstrap/blockstrap-widget-post-title {"text_color":"white","sd_shortcode":"[bs_post_title html_tag='h1'  is_link='false'  stretched_link='false'  text_color='white'  text_color_custom=''  font_size=''  font_size_custom=''  font_line_height=''  font_weight=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_on_text='false'  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  css_class='' ]"} /-->

					<!-- wp:geodirectory/geodir-widget-post-meta {"show_advanced":true,"key":"phone","content":"\u003cdiv class=\u0022geodir-post-meta-container bsui sdel-a413e00c\u0022 \u003e\u003cdiv class=\u0022geodir_post_meta  geodir-field-preview text-\u0022\u003e\u003cspan class=\u0022geodir_post_meta_placeholder\u0022 \u003e\u003ci class=\u0022fas fa-tools\u0022\u003e\u003c/i\u003e \u003cspan class=\u0022geodir_post_meta_title \u0022 \u003ePhone: \u003c/span\u003e\u003c/span\u003ePlaceholder\u003c/div\u003e\u003c/div\u003e","sd_shortcode":"[gd_post_meta title=''  id=''  key='phone'  show=''  no_wrap='false'  location=''  list_hide=''  list_hide_secondary=''  alignment=''  text_alignment=''  text_color=''  font_size=''  mt=''  mr=''  mb=''  ml=''  pt=''  pr=''  pb=''  pl=''  css_class='' ]"} /--></div>
				<!-- /wp:blockstrap/blockstrap-widget-container --></div>
			<!-- /wp:blockstrap/blockstrap-widget-container -->

			<!-- wp:blockstrap/blockstrap-widget-shape-divider {"sd":"curve","sd_position":"bottom","sd_color":"white","sd_invert":true,"styleid":"block-w80hp7z414","sd_shortcode":"[bs_shape_divider sd='curve'  sd_position='bottom'  sd_color='white'  sd_custom_color='#0073aa'  sd_width='200'  sd_height='100'  sd_flip='false'  sd_invert='true'  sd_btf='false'  styleid='block-w80hp7z414' ]"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-shape-divider block-w80hp7z414 blockstrap-shape blockstrap-shape-bottom position-absolute"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="bg-white blockstrap-shape-fill" d="M500,97C126.7,96.3,0.8,19.8,0,0v100l1000,0V1C1000,19.4,873.3,97.8,500,97z"/></svg></div><style>.block-w80hp7z414 { pointer-events: none;background-repeat: no-repeat;bottom:  -1px; left: -1px;right: -1px;line-height: 0;overflow: hidden;margin: 0 1px;}.block-w80hp7z414 svg{ height: 100px;width: calc(200% + 1.3px);left: 50%;position: relative;display: block;-webkit-transform: translateX(-50%); -ms-transform: translateX(-50%); transform: translateX(-50%);}.block-w80hp7z414 svg path{ }</style>
			<!-- /wp:blockstrap/blockstrap-widget-shape-divider --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container -->

		<!-- wp:blockstrap/blockstrap-widget-container {"container":"container-sm","bg_color":"rgba(255,255,255,0.23)","mt_lg":"5","mb_lg":"5","pt_lg":"3","rounded_size":"sm","anchor":"main","sd_shortcode":"[bs_container container='container-sm'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='rgba(255,255,255,0.23)'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg='5'  mr_lg=''  mb_lg='5'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='3'  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size='sm'  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor='main'  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container mt-5 mb-5 pt-3 rounded-sm bg-image-fixed container-sm" id="main"><!-- wp:blockstrap/blockstrap-widget-container {"container":"row","sd_shortcode":"[bs_container container='row'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 bg-image-fixed row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","col":"12","col_md":"12","col_lg":"8","sd_shortcode":"[bs_container container='col'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col='12'  col_md='12'  col_lg='8'  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
				<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 col-12 col-md-12 col-lg-8 bg-image-fixed col"><!-- wp:geodirectory/geodir-widget-notifications {"content":"\u003cdiv class=\u0022geodir-notifications bsui sdel-47d566b2\u0022 \u003e\u003cdiv class=\u0022alert alert-danger \u0022 role=\u0022alert\u0022 \u003e\u003ci class=\u0022fas fa-exclamation-circle\u0022\u003e\u003c/i\u003e This is how error notifications will look on your site.\u003c/div\u003e\u003cdiv class=\u0022alert alert-warning \u0022 role=\u0022alert\u0022 \u003e\u003ci class=\u0022fas fa-exclamation-triangle\u0022\u003e\u003c/i\u003e This is how warning notifications will look on your site.\u003c/div\u003e\u003cdiv class=\u0022alert alert-success  alert-dismissible fade show\u0022 role=\u0022alert\u0022 \u003e\u003ci class=\u0022fas fa-check-circle\u0022\u003e\u003c/i\u003e This is how success notifications will look on your site.\u003cbutton type=\u0022button\u0022 class=\u0022btn-close\u0022 data-bs-dismiss=\u0022alert\u0022 aria-label=\u0022Close\u0022\u003e\u003c/button\u003e\u003c/div\u003e\u003cdiv class=\u0022alert alert-info  alert-dismissible fade show\u0022 role=\u0022alert\u0022 \u003e\u003ci class=\u0022fas fa-info-circle\u0022\u003e\u003c/i\u003e This is how info notifications will look on your site.\u003cbutton type=\u0022button\u0022 class=\u0022btn-close\u0022 data-bs-dismiss=\u0022alert\u0022 aria-label=\u0022Close\u0022\u003e\u003c/button\u003e\u003c/div\u003e\u003c/div\u003e","sd_shortcode":"[gd_notifications]","className":"wp-block-geodirectory-geodir-widget-notifications"} /-->

					<!-- wp:geodirectory/geodir-widget-single-tabs {"show_advanced":true,"content":"\u003cdiv class=\u0022geodir-single-tabs-container bsui sdel-6841e3bb\u0022 \u003e\u003cdiv class=\u0022geodir-tabs mt-3\u0022 id=\u0022gd-tabs\u0022\u003e\u003cnav class=\u0022geodir-tab-head greedy\u0022\u003e\u003cul class=\u0022nav list-unstyled nav-tabs mb-3  overflow-hidden flex-nowrap  mx-0\u0022 id=\u0022gd-single-tabs\u0022 role=\u0022tablist\u0022\u003e\u003cli class=\u0022nav-item list-unstyled mb-0\u0022\u003e\u003ca class=\u0022nav-link text-nowrap scroll-ignore active\u0022  data-bs-toggle=\u0022tab\u0022 href=\u0022#dummy_1\u0022 role=\u0022tab\u0022 aria-controls=\u0022dummy_1\u0022 aria-selected=\u0022true\u0022\u003e\u003ci class=\u0022fas fa-home fa-fw me-1 me-1\u0022 aria-hidden=\u0022true\u0022\u003e\u003c/i\u003eDemo tab 1\u003c/a\u003e\u003c/li\u003e\u003cli class=\u0022nav-item list-unstyled mb-0\u0022\u003e\u003ca class=\u0022nav-link text-nowrap scroll-ignore \u0022  data-bs-toggle=\u0022tab\u0022 href=\u0022#dummy_2\u0022 role=\u0022tab\u0022 aria-controls=\u0022dummy_2\u0022 aria-selected=\u0022false\u0022\u003e\u003ci class=\u0022fas fa-image fa-fw me-1 me-1\u0022 aria-hidden=\u0022true\u0022\u003e\u003c/i\u003eDemo tab 2\u003c/a\u003e\u003c/li\u003e\u003cli class=\u0022nav-item list-unstyled mb-0\u0022\u003e\u003ca class=\u0022nav-link text-nowrap scroll-ignore \u0022  data-bs-toggle=\u0022tab\u0022 href=\u0022#dummy_3\u0022 role=\u0022tab\u0022 aria-controls=\u0022dummy_3\u0022 aria-selected=\u0022false\u0022\u003e\u003ci class=\u0022fas fa-globe-americas fa-fw me-1 me-1\u0022 aria-hidden=\u0022true\u0022\u003e\u003c/i\u003eDemo tab 3\u003c/a\u003e\u003c/li\u003e\u003cli class=\u0022nav-item list-unstyled mb-0\u0022\u003e\u003ca class=\u0022nav-link text-nowrap scroll-ignore \u0022  data-bs-toggle=\u0022tab\u0022 href=\u0022#dummy_4\u0022 role=\u0022tab\u0022 aria-controls=\u0022dummy_4\u0022 aria-selected=\u0022false\u0022\u003e\u003ci class=\u0022fas fa-comments fa-fw me-1 me-1\u0022 aria-hidden=\u0022true\u0022\u003e\u003c/i\u003eDemo tab 4\u003c/a\u003e\u003c/li\u003e\u003cli class=\u0022nav-item list-unstyled mb-0\u0022\u003e\u003ca class=\u0022nav-link text-nowrap scroll-ignore \u0022  data-bs-toggle=\u0022tab\u0022 href=\u0022#dummy_5\u0022 role=\u0022tab\u0022 aria-controls=\u0022dummy_5\u0022 aria-selected=\u0022false\u0022\u003e\u003ci class=\u0022fas fa-bed fa-fw me-1 me-1\u0022 aria-hidden=\u0022true\u0022\u003e\u003c/i\u003eDemo tab 5\u003c/a\u003e\u003c/li\u003e\u003cli class=\u0022nav-item list-unstyled mb-0\u0022\u003e\u003ca class=\u0022nav-link text-nowrap scroll-ignore \u0022  data-bs-toggle=\u0022tab\u0022 href=\u0022#dummy_6\u0022 role=\u0022tab\u0022 aria-controls=\u0022dummy_6\u0022 aria-selected=\u0022false\u0022\u003e\u003ci class=\u0022fas fa-calendar-alt fa-fw me-1 me-1\u0022 aria-hidden=\u0022true\u0022\u003e\u003c/i\u003eDemo tab 6\u003c/a\u003e\u003c/li\u003e\u003cli class=\u0022nav-item list-unstyled mb-0\u0022\u003e\u003ca class=\u0022nav-link text-nowrap scroll-ignore \u0022  data-bs-toggle=\u0022tab\u0022 href=\u0022#dummy_7\u0022 role=\u0022tab\u0022 aria-controls=\u0022dummy_7\u0022 aria-selected=\u0022false\u0022\u003e\u003ci class=\u0022fas fa-bullhorn fa-fw me-1 me-1\u0022 aria-hidden=\u0022true\u0022\u003e\u003c/i\u003eDemo tab 7\u003c/a\u003e\u003c/li\u003e\u003cli class=\u0022nav-item list-unstyled mb-0\u0022\u003e\u003ca class=\u0022nav-link text-nowrap scroll-ignore \u0022  data-bs-toggle=\u0022tab\u0022 href=\u0022#dummy_8\u0022 role=\u0022tab\u0022 aria-controls=\u0022dummy_8\u0022 aria-selected=\u0022false\u0022\u003e\u003ci class=\u0022fas fa-cloud fa-fw me-1 me-1\u0022 aria-hidden=\u0022true\u0022\u003e\u003c/i\u003eDemo tab 8\u003c/a\u003e\u003c/li\u003e\u003c/ul\u003e\u003c/nav\u003e\u003cdiv class=\u0022geodir-tabs-content geodir-entry-content tab-content\u0022 id=\u0022gd-single-tabs-content\u0022\u003e\u003cdiv id=\u0022dummy_1\u0022 class=\u0022tab-pane fade  show active\u0022 role=\u0022tabpanel\u0022 aria-labelledby=\u0022dummy_1\u0022\u003e\u003cspan id='dummy_1-anchor' class='geodir-tabs-anchor'\u003e\u003c/span\u003e\u003cdiv id=\u0022geodir-tab-content-dummy_1\u0022 class=\u0022hash-offset\u0022\u003e\u003c/div\u003eDemo tab content 1. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \u003c/div\u003e\u003cdiv id=\u0022dummy_2\u0022 class=\u0022tab-pane fade \u0022 role=\u0022tabpanel\u0022 aria-labelledby=\u0022dummy_2\u0022\u003e\u003cspan id='dummy_2-anchor' class='geodir-tabs-anchor'\u003e\u003c/span\u003e\u003cdiv id=\u0022geodir-tab-content-dummy_2\u0022 class=\u0022hash-offset\u0022\u003e\u003c/div\u003eDemo tab content 2. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \u003c/div\u003e\u003cdiv id=\u0022dummy_3\u0022 class=\u0022tab-pane fade \u0022 role=\u0022tabpanel\u0022 aria-labelledby=\u0022dummy_3\u0022\u003e\u003cspan id='dummy_3-anchor' class='geodir-tabs-anchor'\u003e\u003c/span\u003e\u003cdiv id=\u0022geodir-tab-content-dummy_3\u0022 class=\u0022hash-offset\u0022\u003e\u003c/div\u003eDemo tab content 3. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \u003c/div\u003e\u003cdiv id=\u0022dummy_4\u0022 class=\u0022tab-pane fade \u0022 role=\u0022tabpanel\u0022 aria-labelledby=\u0022dummy_4\u0022\u003e\u003cspan id='dummy_4-anchor' class='geodir-tabs-anchor'\u003e\u003c/span\u003e\u003cdiv id=\u0022geodir-tab-content-dummy_4\u0022 class=\u0022hash-offset\u0022\u003e\u003c/div\u003eDemo tab content 4. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \u003c/div\u003e\u003cdiv id=\u0022dummy_5\u0022 class=\u0022tab-pane fade \u0022 role=\u0022tabpanel\u0022 aria-labelledby=\u0022dummy_5\u0022\u003e\u003cspan id='dummy_5-anchor' class='geodir-tabs-anchor'\u003e\u003c/span\u003e\u003cdiv id=\u0022geodir-tab-content-dummy_5\u0022 class=\u0022hash-offset\u0022\u003e\u003c/div\u003eDemo tab content 5. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \u003c/div\u003e\u003cdiv id=\u0022dummy_6\u0022 class=\u0022tab-pane fade \u0022 role=\u0022tabpanel\u0022 aria-labelledby=\u0022dummy_6\u0022\u003e\u003cspan id='dummy_6-anchor' class='geodir-tabs-anchor'\u003e\u003c/span\u003e\u003cdiv id=\u0022geodir-tab-content-dummy_6\u0022 class=\u0022hash-offset\u0022\u003e\u003c/div\u003eDemo tab content 6. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \u003c/div\u003e\u003cdiv id=\u0022dummy_7\u0022 class=\u0022tab-pane fade \u0022 role=\u0022tabpanel\u0022 aria-labelledby=\u0022dummy_7\u0022\u003e\u003cspan id='dummy_7-anchor' class='geodir-tabs-anchor'\u003e\u003c/span\u003e\u003cdiv id=\u0022geodir-tab-content-dummy_7\u0022 class=\u0022hash-offset\u0022\u003e\u003c/div\u003eDemo tab content 7. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \u003c/div\u003e\u003cdiv id=\u0022dummy_8\u0022 class=\u0022tab-pane fade \u0022 role=\u0022tabpanel\u0022 aria-labelledby=\u0022dummy_8\u0022\u003e\u003cspan id='dummy_8-anchor' class='geodir-tabs-anchor'\u003e\u003c/span\u003e\u003cdiv id=\u0022geodir-tab-content-dummy_8\u0022 class=\u0022hash-offset\u0022\u003e\u003c/div\u003eDemo tab content 8. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \u003c/div\u003e\u003c/div\u003e\u003c/div\u003e\u003cscript type=\u0022text/javascript\u0022\u003e/* \u003c![CDATA[ */\n\tvar hashVal;\n\tif (window.location.hash) {\n\t\tif (window.location.hash.indexOf('\u0026') === -1) {\n\t\t\tif (jQuery(window.location.hash + 'Tab').length) {\n\t\t\t\thashVal = window.location.hash;\n\t\t\t}\n\t\t}\n\t}\n\tif (!hashVal) {\n\t\thashVal = jQuery('dl.geodir-tab-head dd.geodir-tab-active').find('a').attr('data-tab');\n\t}\n\tjQuery('dl.geodir-tab-head dd').each(function() {\n\t\t/* Get all tabs */\n\t\tvar tabs = jQuery(this).children('dd');\n\t\tvar tab = '';\n\t\ttab = jQuery(this).find('a').attr('data-tab');\n\t\tif (hashVal != tab) {\n\t\t\tjQuery(tab + 'Tab').hide();\n\t\t}\n\t});\n\t/* ]]\u003e */\u003c/script\u003e\n\t\t\u003c/div\u003e","sd_shortcode":"[gd_single_tabs show_as_list='false'  output=''  tab_style=''  disable_greedy='false'  remove_separator_line='false'  hide_icon='false'  heading_tag=''  heading_font_size=''  heading_text_color=''  heading_text_color_custom=''  heading_font_weight=''  lists_mb=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg='3'  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  display=''  display_md=''  display_lg=''  css_class='' ]"} -->
					<div class="wp-block-geodirectory-geodir-widget-single-tabs"></div>
					<!-- /wp:geodirectory/geodir-widget-single-tabs --></div>
				<!-- /wp:blockstrap/blockstrap-widget-container -->

				<!-- wp:blockstrap/blockstrap-widget-container {"container":"col","sd_shortcode":"[bs_container container='col'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
				<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 bg-image-fixed col"><!-- wp:blockstrap/blockstrap-widget-container {"container":"list-group","text_color":"dark","mb_lg":"","shadow":"shadow","position":"sticky-top","sticky_offset_top":115,"sd_shortcode":"[bs_container container='list-group'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color='dark'  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow='shadow'  position='sticky-top'  sticky_offset_top='115'  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
					<div class="wp-block-blockstrap-blockstrap-widget-container bg-image-fixed text-dark list-group sticky-top shadow" style="top:115px"><!-- wp:blockstrap/blockstrap-widget-container {"container":"list-group-item","mb_lg":"","sd_shortcode":"[bs_container container='list-group-item'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
						<div class="wp-block-blockstrap-blockstrap-widget-container bg-image-fixed list-group-item"><!-- wp:geodirectory/geodir-widget-post-meta {"key":"post_tags","content":"\u003cdiv class=\u0022geodir-post-meta-container bsui sdel-e82a91eb\u0022 \u003e\u003cdiv class=\u0022geodir_post_meta  geodir-field-preview  clear-both  text- text-\u0022\u003e\u003cspan class=\u0022geodir_post_meta_placeholder\u0022 \u003e\u003ci class=\u0022fas fa-tools\u0022\u003e\u003c/i\u003e \u003cspan class=\u0022geodir_post_meta_title \u0022 \u003ePost Tags: \u003c/span\u003e\u003c/span\u003ePlaceholder\u003c/div\u003e\u003c/div\u003e","sd_shortcode":"[gd_post_meta title=''  id=''  key='post_tags'  show=''  no_wrap='false'  location=''  list_hide=''  list_hide_secondary=''  alignment=''  text_alignment=''  text_color=''  font_size=''  mt=''  mr=''  mb=''  ml=''  pt=''  pr=''  pb=''  pl=''  css_class='' ]"} /--></div>
						<!-- /wp:blockstrap/blockstrap-widget-container -->

						<!-- wp:blockstrap/blockstrap-widget-container {"container":"list-group-item","mb_lg":"","sd_shortcode":"[bs_container container='list-group-item'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
						<div class="wp-block-blockstrap-blockstrap-widget-container bg-image-fixed list-group-item"><!-- wp:geodirectory/geodir-widget-post-meta {"key":"post_category","content": "","sd_shortcode":"[gd_post_meta title=''  id=''  key='post_category'  show=''  no_wrap='false'  location=''  list_hide=''  list_hide_secondary=''  alignment=''  text_alignment=''  text_color=''  font_size=''  mt=''  mr=''  mb=''  ml=''  pt=''  pr=''  pb=''  pl=''  css_class='' ]"} /--></div>
						<!-- /wp:blockstrap/blockstrap-widget-container -->

						<!-- wp:blockstrap/blockstrap-widget-container {"container":"list-group-item","mb_lg":"","sd_shortcode":"[bs_container container='list-group-item'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
						<div class="wp-block-blockstrap-blockstrap-widget-container bg-image-fixed list-group-item"><!-- wp:geodirectory/geodir-widget-post-meta {"key":"address","content":"\u003cdiv class=\u0022geodir-post-meta-container bsui sdel-9d496b90\u0022 \u003e\u003cdiv class=\u0022geodir_post_meta  geodir-field-preview text-\u0022\u003e\u003cspan class=\u0022geodir_post_meta_placeholder\u0022 \u003e\u003ci class=\u0022fas fa-tools\u0022\u003e\u003c/i\u003e \u003cspan class=\u0022geodir_post_meta_title \u0022 \u003eAddress: \u003c/span\u003e\u003c/span\u003ePlaceholder\u003c/div\u003e\u003c/div\u003e","sd_shortcode":"[gd_post_meta title=''  id=''  key='address'  show=''  no_wrap='false'  location=''  list_hide=''  list_hide_secondary=''  alignment=''  text_alignment=''  text_color=''  font_size=''  mt=''  mr=''  mb=''  ml=''  pt=''  pr=''  pb=''  pl=''  css_class='' ]"} /--></div>
						<!-- /wp:blockstrap/blockstrap-widget-container -->

						<!-- wp:blockstrap/blockstrap-widget-container {"container":"list-group-item","mb_lg":"","sd_shortcode":"[bs_container container='list-group-item'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
						<div class="wp-block-blockstrap-blockstrap-widget-container bg-image-fixed list-group-item"><!-- wp:geodirectory/geodir-widget-post-meta {"key":"phone","content":"\u003cdiv class=\u0022geodir-post-meta-container bsui sdel-3f12a013\u0022 \u003e\u003cdiv class=\u0022geodir_post_meta  geodir-field-preview text-\u0022\u003e\u003cspan class=\u0022geodir_post_meta_placeholder\u0022 \u003e\u003ci class=\u0022fas fa-tools\u0022\u003e\u003c/i\u003e \u003cspan class=\u0022geodir_post_meta_title \u0022 \u003ePhone: \u003c/span\u003e\u003c/span\u003ePlaceholder\u003c/div\u003e\u003c/div\u003e","sd_shortcode":"[gd_post_meta title=''  id=''  key='phone'  show=''  no_wrap='false'  location=''  list_hide=''  list_hide_secondary=''  alignment=''  text_alignment=''  text_color=''  font_size=''  mt=''  mr=''  mb=''  ml=''  pt=''  pr=''  pb=''  pl=''  css_class='' ]"} /--></div>
						<!-- /wp:blockstrap/blockstrap-widget-container -->

						<!-- wp:blockstrap/blockstrap-widget-container {"container":"list-group-item","mb_lg":"","sd_shortcode":"[bs_container container='list-group-item'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
						<div class="wp-block-blockstrap-blockstrap-widget-container bg-image-fixed list-group-item"><!-- wp:geodirectory/geodir-widget-post-meta {"key":"email","content":"\u003cdiv class=\u0022geodir-post-meta-container bsui sdel-428340c9\u0022 \u003e\u003cdiv class=\u0022geodir_post_meta  geodir-field-preview text-\u0022\u003e\u003cspan class=\u0022geodir_post_meta_placeholder\u0022 \u003e\u003ci class=\u0022fas fa-tools\u0022\u003e\u003c/i\u003e \u003cspan class=\u0022geodir_post_meta_title \u0022 \u003eEmail: \u003c/span\u003e\u003c/span\u003ePlaceholder\u003c/div\u003e\u003c/div\u003e","sd_shortcode":"[gd_post_meta title=''  id=''  key='email'  show=''  no_wrap='false'  location=''  list_hide=''  list_hide_secondary=''  alignment=''  text_alignment=''  text_color=''  font_size=''  mt=''  mr=''  mb=''  ml=''  pt=''  pr=''  pb=''  pl=''  css_class='' ]"} /--></div>
						<!-- /wp:blockstrap/blockstrap-widget-container -->

						<!-- wp:blockstrap/blockstrap-widget-container {"container":"list-group-item","mb_lg":"","sd_shortcode":"[bs_container container='list-group-item'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
						<div class="wp-block-blockstrap-blockstrap-widget-container bg-image-fixed list-group-item"><!-- wp:geodirectory/geodir-widget-post-meta {"key":"website","content":"\u003cdiv class=\u0022geodir-post-meta-container bsui sdel-3f8715c5\u0022 \u003e\u003cdiv class=\u0022geodir_post_meta  geodir-field-preview text-\u0022\u003e\u003cspan class=\u0022geodir_post_meta_placeholder\u0022 \u003e\u003ci class=\u0022fas fa-tools\u0022\u003e\u003c/i\u003e \u003cspan class=\u0022geodir_post_meta_title \u0022 \u003eWebsite: \u003c/span\u003e\u003c/span\u003ePlaceholder\u003c/div\u003e\u003c/div\u003e","sd_shortcode":"[gd_post_meta title=''  id=''  key='website'  show=''  no_wrap='false'  location=''  list_hide=''  list_hide_secondary=''  alignment=''  text_alignment=''  text_color=''  font_size=''  mt=''  mr=''  mb=''  ml=''  pt=''  pr=''  pb=''  pl=''  css_class='' ]"} /--></div>
						<!-- /wp:blockstrap/blockstrap-widget-container -->

						<!-- wp:blockstrap/blockstrap-widget-container {"container":"list-group-item","mb_lg":"","sd_shortcode":"[bs_container container='list-group-item'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
						<div class="wp-block-blockstrap-blockstrap-widget-container bg-image-fixed list-group-item"><!-- wp:geodirectory/geodir-widget-post-meta {"key":"twitter","content":"\u003cdiv class=\u0022geodir-post-meta-container bsui sdel-1cfab6cb\u0022 \u003e\u003cdiv class=\u0022geodir_post_meta  geodir-field-preview text-\u0022\u003e\u003cspan class=\u0022geodir_post_meta_placeholder\u0022 \u003e\u003ci class=\u0022fas fa-tools\u0022\u003e\u003c/i\u003e \u003cspan class=\u0022geodir_post_meta_title \u0022 \u003eX: \u003c/span\u003e\u003c/span\u003ePlaceholder\u003c/div\u003e\u003c/div\u003e","sd_shortcode":"[gd_post_meta title=''  id=''  key='twitter'  show=''  no_wrap='false'  location=''  list_hide=''  list_hide_secondary=''  alignment=''  text_alignment=''  text_color=''  font_size=''  mt=''  mr=''  mb=''  ml=''  pt=''  pr=''  pb=''  pl=''  css_class='' ]"} /--></div>
						<!-- /wp:blockstrap/blockstrap-widget-container -->

						<!-- wp:blockstrap/blockstrap-widget-container {"container":"list-group-item","mb_lg":"","sd_shortcode":"[bs_container container='list-group-item'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
						<div class="wp-block-blockstrap-blockstrap-widget-container bg-image-fixed list-group-item"><!-- wp:geodirectory/geodir-widget-post-meta {"key":"facebook","content":"\u003cdiv class=\u0022geodir-post-meta-container bsui sdel-358ff89b\u0022 \u003e\u003cdiv class=\u0022geodir_post_meta  geodir-field-preview text-\u0022\u003e\u003cspan class=\u0022geodir_post_meta_placeholder\u0022 \u003e\u003ci class=\u0022fas fa-tools\u0022\u003e\u003c/i\u003e \u003cspan class=\u0022geodir_post_meta_title \u0022 \u003eFacebook: \u003c/span\u003e\u003c/span\u003ePlaceholder\u003c/div\u003e\u003c/div\u003e","sd_shortcode":"[gd_post_meta title=''  id=''  key='facebook'  show=''  no_wrap='false'  location=''  list_hide=''  list_hide_secondary=''  alignment=''  text_alignment=''  text_color=''  font_size=''  mt=''  mr=''  mb=''  ml=''  pt=''  pr=''  pb=''  pl=''  css_class='' ]"} /--></div>
						<!-- /wp:blockstrap/blockstrap-widget-container -->

						<!-- wp:blockstrap/blockstrap-widget-container {"container":"list-group-item","mb_lg":"0","sd_shortcode":"[bs_container container='list-group-item'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='0'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
						<div class="wp-block-blockstrap-blockstrap-widget-container mb-0 bg-image-fixed list-group-item"><!-- wp:geodirectory/geodir-widget-post-meta {"key":"business_hours","content":"\u003cdiv class=\u0022geodir-post-meta-container bsui sdel-5f65dc26\u0022 \u003e\u003cdiv class=\u0022geodir_post_meta  geodir-field-preview text-\u0022\u003e\u003cspan class=\u0022geodir_post_meta_placeholder\u0022 \u003e\u003ci class=\u0022fas fa-tools\u0022\u003e\u003c/i\u003e \u003cspan class=\u0022geodir_post_meta_title \u0022 \u003eBusiness Hours: \u003c/span\u003e\u003c/span\u003ePlaceholder\u003c/div\u003e\u003c/div\u003e","sd_shortcode":"[gd_post_meta title=''  id=''  key='business_hours'  show=''  no_wrap='false'  location=''  list_hide=''  list_hide_secondary=''  alignment=''  text_alignment=''  text_color=''  font_size=''  mt=''  mr=''  mb=''  ml=''  pt=''  pr=''  pb=''  pl=''  css_class='' ]"} /--></div>
						<!-- /wp:blockstrap/blockstrap-widget-container --></div>
					<!-- /wp:blockstrap/blockstrap-widget-container --></div>
				<!-- /wp:blockstrap/blockstrap-widget-container --></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container -->

		<!-- wp:blockstrap/blockstrap-widget-container {"container":"container-fluid","bg":"transparent","bg_color":"#f5f9fe","mt_lg":"5","mb_lg":"","pt_lg":"5","pb_lg":"0","sd_shortcode":"[bs_container container='container-fluid'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg='transparent'  bg_color='#f5f9fe'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg='5'  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg='0'  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container mt-5 pt-5 pb-0 bg-transparent bg-image-fixed container-fluid"><!-- wp:blockstrap/blockstrap-widget-container {"text_color":"dark","mb_lg":"","pt_lg":"5","pb_lg":"5","display":"d-none","display_lg":"d-lg-block","sd_shortcode":"[bs_container container='container'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color='dark'  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg='5'  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display='d-none'  display_md=''  display_lg='d-lg-block'  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"block-1618467995"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container pt-5 pb-5 bg-image-fixed text-dark d-none d-lg-block container"><!-- wp:heading {"style":{"spacing":{"margin":{"bottom":"60px"}}},"textColor":"gray-dark"} -->
				<h2 class="wp-block-heading has-gray-dark-color has-text-color" style="margin-bottom:60px">Similar places</h2>
				<!-- /wp:heading -->

				<!-- wp:geodirectory/geodir-widget-listings {"show_advanced":true,"hide_if_empty":true,"related_to":"category","post_limit":9,"layout":"3","view_all_link":false,"template_type":"template_part","tmpl_part":"gd-archive-item","with_carousel":"1","with_indicators":"1","indicators_mb":"5","with_controls":"1","slide_interval":6,"content": "","sd_shortcode":"[gd_listings title=''  widget_title_tag=''  widget_title_size_class=''  widget_title_align_class=''  widget_title_color_class=''  widget_title_border_class=''  widget_title_border_color_class=''  widget_title_mt_class=''  widget_title_mr_class=''  widget_title_mb_class=''  widget_title_ml_class=''  widget_title_pt_class=''  widget_title_pr_class=''  widget_title_pb_class=''  widget_title_pl_class=''  hide_if_empty='true'  post_type='gd_place'  category=''  related_to='category'  tags=''  post_author=''  post_limit='9'  post_ids=''  add_location_filter='true'  nearby_gps='false'  show_featured_only='false'  show_special_only='false'  with_pics_only='false'  with_videos_only='false'  show_favorites_only='false'  favorites_by_user=''  use_viewing_post_type='false'  use_viewing_term='false'  sort_by=''  title_tag='h3'  layout='3'  view_all_link='false'  with_pagination='false'  top_pagination='false'  bottom_pagination='true'  pagination_info=''  template_type='template_part'  tmpl_page=''  tmpl_part='gd-archive-item'  row_gap=''  column_gap=''  card_border=''  card_shadow=''  with_carousel='1'  with_indicators='1'  indicators_mb='5'  with_controls='1'  slide_interval='6'  slide_ride=''  center_slide=''  bg=''  mt=''  mr=''  mb='3'  ml=''  pt=''  pr=''  pb=''  pl=''  border=''  rounded=''  rounded_size=''  shadow=''  css_class='' ]"} -->
				<div class="wp-block-geodirectory-geodir-widget-listings"></div>
				<!-- /wp:geodirectory/geodir-widget-listings --></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container -->

		<!-- wp:blockstrap/blockstrap-widget-container {"container":"container-fluid","bg":"light","mb_lg":"","shadow":"shadow","position":"fixed-bottom","display":"d-block","display_md":"d-md-none","display_lg":"d-lg-none","sd_shortcode":"[bs_container container='container-fluid'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg='light'  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow='shadow'  position='fixed-bottom'  sticky_offset_top=''  sticky_offset_bottom=''  display='d-block'  display_md='d-md-none'  display_lg='d-lg-none'  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container bg-light bg-image-fixed d-block d-md-none d-lg-none container-fluid fixed-bottom shadow"><!-- wp:blockstrap/blockstrap-widget-container {"container":"row","text_color":"dark","text_align_lg":"text-lg-center","mb_lg":"","sd_shortcode":"[bs_container container='row'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color='dark'  text_justify='false'  text_align=''  text_align_md=''  text_align_lg='text-lg-center'  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container bg-image-fixed text-dark text-center row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","mb_lg":"","sd_shortcode":"[bs_container container='col'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
				<div class="wp-block-blockstrap-blockstrap-widget-container bg-image-fixed col"><!-- wp:geodirectory/geodir-widget-post-badge {"key":"phone","condition":"is_not_empty","icon_class":"fas fa-phone","badge":" ","link":"%%input%%","new_window":true,"bg_color":"#ffffff00","txt_color":"#8500f9","size":"h1","content":"\u003cspan class=\u0022bsui gd-badge-meta\u0022\u003e\u003cspan class=\u0022h1\u0022\u003e\u003cspan  class=\u0022gd-badge border-0 badge\u0022  data-id=\u00220\u0022  data-badge=\u0022\u0022  data-badge-condition=\u0022is_not_empty\u0022  onclick=\u0022 if(typeof ga == 'function' \u0026\u0026 !jQuery(this).hasClass('gd-event-tracked')) { ga('send', 'event', {eventCategory: 'CTA',eventAction: '',transport: 'beacon' });jQuery(this).addClass('gd-event-tracked');} \u0022  style=\u0022background-color:#ffffff00;border-color:#ffffff00;color:#8500f9;\u0022  \u003e\u003ci class=\u0022fas fa-phone\u0022 \u003e\u003c/i\u003e  \u003cspan class='gd-secondary gv-secondary'\u003e \u003c/span\u003e\u003c/span\u003e\n\u003c/span\u003e\u003c/span\u003e","sd_shortcode":"[gd_post_badge id=''  key='phone'  condition='is_not_empty'  search=''  icon_class='fas fa-phone'  badge=' '  link='%%input%%'  new_window='true'  popover_title=''  popover_text=''  cta=''  tooltip_text=''  hover_content=''  hover_icon=''  type=''  shadow=''  color=''  bg_color='#ffffff00'  txt_color='#8500f9'  size='h1'  alignment=''  position=''  mt=''  mr=''  mb=''  ml=''  list_hide=''  list_hide_secondary=''  css_class='' ]"} /--></div>
				<!-- /wp:blockstrap/blockstrap-widget-container -->

				<!-- wp:blockstrap/blockstrap-widget-container {"container":"col","mb_lg":"","border":"0","sd_shortcode":"[bs_container container='col'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border='0'  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
				<div class="wp-block-blockstrap-blockstrap-widget-container border-0 bg-image-fixed col"><!-- wp:geodirectory/geodir-widget-post-badge {"key":"website","condition":"is_not_empty","icon_class":"fas fa-globe","badge":" ","link":"%%input%%","new_window":true,"bg_color":"#ffffff00","txt_color":"#8500f9","size":"h1","content":"\u003cspan class=\u0022bsui gd-badge-meta\u0022\u003e\u003cspan class=\u0022h1\u0022\u003e\u003cspan  class=\u0022gd-badge border-0 badge\u0022  data-id=\u00220\u0022  data-badge=\u0022\u0022  data-badge-condition=\u0022is_not_empty\u0022  onclick=\u0022 if(typeof ga == 'function' \u0026\u0026 !jQuery(this).hasClass('gd-event-tracked')) { ga('send', 'event', {eventCategory: 'CTA',eventAction: '',transport: 'beacon' });jQuery(this).addClass('gd-event-tracked');} \u0022  style=\u0022background-color:#ffffff00;border-color:#ffffff00;color:#8500f9;\u0022  \u003e\u003ci class=\u0022fas fa-globe\u0022 \u003e\u003c/i\u003e  \u003cspan class='gd-secondary gv-secondary'\u003e \u003c/span\u003e\u003c/span\u003e\n\u003c/span\u003e\u003c/span\u003e","sd_shortcode":"[gd_post_badge id=''  key='website'  condition='is_not_empty'  search=''  icon_class='fas fa-globe'  badge=' '  link='%%input%%'  new_window='true'  popover_title=''  popover_text=''  cta=''  tooltip_text=''  hover_content=''  hover_icon=''  type=''  shadow=''  color=''  bg_color='#ffffff00'  txt_color='#8500f9'  size='h1'  alignment=''  position=''  mt=''  mr=''  mb=''  ml=''  list_hide=''  list_hide_secondary=''  css_class='' ]"} /--></div>
				<!-- /wp:blockstrap/blockstrap-widget-container --></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container -->
		<?php
		return ob_get_clean();
	}

	/**
	 * Add content to the GD search page template of the BLockStrap theme.
	 *
	 * @param $content
	 *
	 * @return string
	 */
	public static function search_template( $content ) {
		return self::archive_template( $content );
	}

	/**
	 * Add content to the GD archive page template of the BLockStrap theme.
	 *
	 * @param $content
	 *
	 * @return string
	 */
	public static function archive_template( $content ) {
		ob_start();
		?>
		<!-- wp:blockstrap/blockstrap-widget-container {"container":"container-fluid","bg":"custom-gradient","bg_gradient":"linear-gradient(135deg,rgb(2,11,185) 2%,rgb(126,5,170) 100%)","position":"position-relative","sd_shortcode":"[bs_container container='container-fluid'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg='custom-gradient'  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgb(2,11,185) 2%,rgb(126,5,170) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position='position-relative'  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 bg-custom-gradient bg-image-fixed container-fluid position-relative" style="background-image:linear-gradient(135deg,rgb(2,11,185) 2%,rgb(126,5,170) 100%)"><!-- wp:blockstrap/blockstrap-widget-shape-divider {"sd":"curve","sd_position":"bottom","sd_color":"white","sd_width":"140","sd_invert":true,"styleid":"block-xu9bmn6lkf","sd_shortcode":"[bs_shape_divider sd='curve'  sd_position='bottom'  sd_color='white'  sd_custom_color='#0073aa'  sd_width='140'  sd_height='100'  sd_flip='false'  sd_invert='true'  sd_btf='false'  styleid='block-xu9bmn6lkf' ]"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-shape-divider block-xu9bmn6lkf blockstrap-shape blockstrap-shape-bottom position-absolute"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="bg-white blockstrap-shape-fill" d="M500,97C126.7,96.3,0.8,19.8,0,0v100l1000,0V1C1000,19.4,873.3,97.8,500,97z"/></svg></div><style>.block-xu9bmn6lkf { pointer-events: none;background-repeat: no-repeat;bottom:  -1px; left: -1px;right: -1px;line-height: 0;overflow: hidden;margin: 0 1px;}.block-xu9bmn6lkf svg{ height: 100px;width: calc(140% + 1.3px);left: 50%;position: relative;display: block;-webkit-transform: translateX(-50%); -ms-transform: translateX(-50%); transform: translateX(-50%);}.block-xu9bmn6lkf svg path{ }</style>
			<!-- /wp:blockstrap/blockstrap-widget-shape-divider -->

			<!-- wp:blockstrap/blockstrap-widget-container {"mt_lg":"0","pt_lg":"5","pb_lg":"2","sd_shortcode":"[bs_container container='container'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg='0'  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg='2'  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mt-0 mb-3 pt-5 pb-2 bg-image-fixed container"><!-- wp:blockstrap/blockstrap-widget-container {"container":"row","row_cols_lg":"1","sd_shortcode":"[bs_container container='row'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg='1'  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
				<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 row-cols-1 bg-image-fixed row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","text_align_lg":"text-lg-center","mt_lg":"4","mb_lg":"","pt_lg":"5","sd_shortcode":"[bs_container container='col'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg='text-lg-center'  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg='4'  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
					<div class="wp-block-blockstrap-blockstrap-widget-container mt-4 pt-5 bg-image-fixed text-center col"><!-- wp:blockstrap/blockstrap-widget-archive-title {"text_color":"white","sd_shortcode":"[bs_archive_title html_tag='h1'  prefix_hide='false'  text_color='white'  text_color_custom=''  font_size=''  font_size_custom=''  font_weight=''  font_line_height=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_on_text='false'  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  css_class='' ]"} /-->

						<!-- wp:term-description {"textColor":"white"} /--></div>
					<!-- /wp:blockstrap/blockstrap-widget-container -->

					<!-- wp:blockstrap/blockstrap-widget-container {"container":"col","col":"12","col_md":"12","col_lg":"8","text_align_lg":"text-lg-center","mr_lg":"auto","mb_lg":"","ml_lg":"auto","pb_lg":"5","sd_shortcode":"[bs_container container='col'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col='12'  col_md='12'  col_lg='8'  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg='text-lg-center'  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg='auto'  mb_lg=''  ml_lg='auto'  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg='5'  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
					<div class="wp-block-blockstrap-blockstrap-widget-container me-auto ms-auto pb-5 col-12 col-md-12 col-lg-8 bg-image-fixed text-center col"><!-- wp:geodirectory/geodir-widget-search {"mt":"5","mb":"0","content": "","sd_shortcode":"[gd_search hide_search_input='false'  hide_near_input='false'  input_size=''  bar_flex_wrap=''  bar_flex_wrap_md=''  bar_flex_wrap_lg=''  input_border=''  input_border_opacity=''  input_rounded_size=''  btn_bg=''  btn_rounded_size=''  btn_rounded_size_md=''  btn_rounded_size_lg=''  bg=''  mt='5'  mr=''  mb='0'  ml=''  pt=''  pr=''  pb=''  pl=''  border=''  rounded=''  rounded_size=''  rounded_size_md=''  rounded_size_lg=''  shadow=''  css_class='' ]"} -->
						<div class="wp-block-geodirectory-geodir-widget-search"></div>
						<!-- /wp:geodirectory/geodir-widget-search --></div>
					<!-- /wp:blockstrap/blockstrap-widget-container --></div>
				<!-- /wp:blockstrap/blockstrap-widget-container --></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container -->

		<!-- wp:blockstrap/blockstrap-widget-container {"container":"container-fluid","pt_lg":"3","anchor":"main","sd_shortcode":"[bs_container container='container-fluid'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='3'  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor='main'  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 pt-3 bg-image-fixed container-fluid" id="main"><!-- wp:blockstrap/blockstrap-widget-container {"container":"row","row_cols":"1","row_cols_md":"2","row_cols_lg":"2","sd_shortcode":"[bs_container container='row'  h100=''  row_cols='1'  row_cols_md='2'  row_cols_lg='2'  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 row-cols-1 row-cols-md-2 row-cols-lg-2 bg-image-fixed row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","css_class":"z-index\u002d\u002d2","sd_shortcode":"[bs_container container='col'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='z-index\u002d\u002d2' ]","sd_shortcode_close":"[/bs_container]"} -->
				<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 bg-image-fixed col z-index--2"><!-- wp:geodirectory/geodir-widget-loop-actions {"hide_layouts":["4","5"],"content":"\u003cdiv class=\u0022geodir-loop-actions-container bsui sdel-b0b7528a\u0022 \u003e\u003cdiv class=\u0022justify-content-end mb-3\u0022 role=\u0022toolbar\u0022 aria-label=\u0022Listing sort and view options\u0022\u003e\n\t\u003cscript type=\u0022text/javascript\u0022\u003e/* \u003c![CDATA[ */\n\t\tfunction geodir_list_view_select($val, $noStore) {\n\n\t\tvar $storage_key = \u0022gd_list_view\u0022;\n\t\tvar $list = jQuery('.geodir-loop-container \u003e .row');\n\t\tif(!$list.length){\n\t\t\t$list = jQuery('.geodir-listings \u003e .row');\n\t\t\t$storage_key = \u0022gd_widget_list_view\u0022;\n\t\t}\n\n\t\tvar $listSelect = jQuery('.gd-list-view-select');\n\n\t\t/* Hide button on non-GD layouts */\n\t\tif ($listSelect.length \u0026\u0026 ! $list.length) {\n\t\t\t$listSelect.addClass('d-none');\n\t\t}\n\n\t\t$listSelect.find('button').removeClass('active');\n\t\t$listSelect.find('button[data-gridview=\u0022'+$val+'\u0022]').addClass('active');\n\t\t$list.removeClass('row-cols-md-0 row-cols-md-1 row-cols-md-2 row-cols-md-3 row-cols-md-4 row-cols-md-5').addClass('row-cols-sm-2 row-cols-md-'+$val);\n\n\t\t// only store if it was a user action\n\t\tif (!$noStore) {\n\t\t\t// store the user selection\n\t\t\tlocalStorage.setItem($storage_key, $val);\n\t\t}\n\n\t\t// trigger the window resize event to force any image/map resize\n\t\tjQuery(window).trigger('resize');\n\t}\n\n\t// set the current user selection if set\n\tsetTimeout(function () {\n\t\tif (typeof(Storage) !== \u0022undefined\u0022) {\n\t\t\tvar $storage_key = \u0022gd_list_view\u0022;\n\t\t\tvar $list = jQuery('.geodir-loop-container \u003e .row');\n\t\t\tif(!$list.length){\n\t\t\t\t$list = jQuery('.geodir-listings \u003e .row');\n\t\t\t\t$storage_key = \u0022gd_widget_list_view\u0022;\n\t\t\t}\n\t\t\tvar $noStore = false;\n\t\t\tvar gd_list_view = localStorage.getItem($storage_key);\n\t\t\tif (!gd_list_view) {\n\t\t\t\t$noStore = true;\n\t\t\t\tif ($list.hasClass('row-cols-md-0')) {\n\t\t\t\t\tgd_list_view = 0;\n\t\t\t\t} else if($list.hasClass('row-cols-md-1')){\n\t\t\t\t\tgd_list_view = 1;\n\t\t\t\t} else if($list.hasClass('row-cols-md-2')){\n\t\t\t\t\tgd_list_view = 2;\n\t\t\t\t} else if($list.hasClass('row-cols-md-3')){\n\t\t\t\t\tgd_list_view = 3;\n\t\t\t\t} else if($list.hasClass('row-cols-md-4')){\n\t\t\t\t\tgd_list_view = 4;\n\t\t\t\t}else if($list.hasClass('row-cols-md-5')){\n\t\t\t\t\tgd_list_view = 5;\n\t\t\t\t} else {\n\t\t\t\t\tgd_list_view = 3;\n\t\t\t\t}\n\t\t\t}\n\t\t\tgeodir_list_view_select(gd_list_view, $noStore);\n\t\t}\n\t}, 10); // we need to give it a very short time so the page loads the actual html\n\t/* ]]\u003e */\u003c/script\u003e\n\u003cdiv class=\u0022btn-group btn-group-sm gd-list-view-select\u0022 role=\u0022group\u0022 aria-label=\u0022List View\u0022\u003e\n\t\u003cdiv class=\u0022btn-group btn-group-sm\u0022 role=\u0022group\u0022\u003e\n\t\t\u003cbutton id=\u0022gd-list-view-select-grid\u0022 type=\u0022button\u0022 class=\u0022btn btn-outline-primary dropdown-toggle dropdown-toggle-0 rounded-end gd-list-view-select-grid\u0022 data-bs-toggle=\u0022dropdown\u0022 aria-haspopup=\u0022true\u0022 aria-expanded=\u0022false\u0022 aria-label=\u0022Select View\u0022\u003e\n\t\t\t\u003ci class=\u0022fas fa-th\u0022\u003e\u003c/i\u003e\n\t\t\u003c/button\u003e\n\t\t\u003cdiv class=\u0022dropdown-menu dropdown-caret-0 my-3 p-0\u0022 aria-labelledby=\u0022gd-list-view-select-grid\u0022\u003e\n\t\t\t\t\t\t\t\t\t\u003ca href=\u0022javascript:void(0);\u0022 class=\u0022dropdown-item\u0022 data-gridview=\u00221\u0022 onclick=\u0022geodir_list_view_select(1);return false;\u0022\u003eView: Grid 1\u003c/a\u003e\n\t\t\t\t\t\t\t\t\t\t\t\t\u003ca href=\u0022javascript:void(0);\u0022 class=\u0022dropdown-item\u0022 data-gridview=\u00222\u0022 onclick=\u0022geodir_list_view_select(2);return false;\u0022\u003eView: Grid 2\u003c/a\u003e\n\t\t\t\t\t\t\t\t\t\t\t\t\u003ca href=\u0022javascript:void(0);\u0022 class=\u0022dropdown-item\u0022 data-gridview=\u00223\u0022 onclick=\u0022geodir_list_view_select(3);return false;\u0022\u003eView: Grid 3\u003c/a\u003e\n\t\t\t\t\t\t\t\t\t\t\t\t\u003ca href=\u0022javascript:void(0);\u0022 class=\u0022dropdown-item\u0022 data-gridview=\u00220\u0022 onclick=\u0022geodir_list_view_select(0);return false;\u0022\u003eView: List\u003c/a\u003e\n\t\t\t\t\t\t\t\t\u003c/div\u003e\n\t\u003c/div\u003e\n\u003c/div\u003e\n\u003c/div\u003e\u003c/div\u003e","sd_shortcode":"[gd_loop_actions hide_layouts='4,5'  btn_size=''  btn_style=''  btn_bg=''  btn_border=''  text_color=''  text_align=''  text_align_md=''  text_align_lg=''  bg=''  mt=''  mr=''  mb='3'  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  display=''  display_md=''  display_lg=''  css_class='' ]"} -->
					<div class="wp-block-geodirectory-geodir-widget-loop-actions"></div>
					<!-- /wp:geodirectory/geodir-widget-loop-actions -->

					<!-- wp:geodirectory/geodir-widget-loop {"template_type":"template_part","tmpl_part":"gd-archive-item","content": "","sd_shortcode":"[gd_loop layout='2'  row_gap=''  column_gap=''  card_border=''  card_shadow=''  bg=''  mt=''  mr=''  mb=''  ml=''  pt=''  pr=''  pb=''  pl=''  border=''  rounded=''  rounded_size=''  shadow=''  template_type='template_part'  tmpl_page=''  tmpl_part='gd-archive-item' ]"} -->
					<div class="wp-block-geodirectory-geodir-widget-loop"></div>
					<!-- /wp:geodirectory/geodir-widget-loop -->

					<!-- wp:geodirectory/geodir-widget-loop-paging {"content": "","sd_shortcode":"[gd_loop_paging show_advanced=''  mid_size=''  mid_size_sm=''  paging_style=''  size=''  size_sm=''  ap_text_color=''  ap_font_size=''  ap_pt=''  ap_pr=''  ap_pb=''  ap_pl=''  bg=''  mt=''  mr=''  mb='3'  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  display=''  display_md=''  display_lg=''  css_class='' ]"} -->
					<div class="wp-block-geodirectory-geodir-widget-loop-paging"></div>
					<!-- /wp:geodirectory/geodir-widget-loop-paging --></div>
				<!-- /wp:blockstrap/blockstrap-widget-container -->

				<!-- wp:blockstrap/blockstrap-widget-container {"container":"col","mt_lg":"5","pr_lg":"0","pl_lg":"0","css_class":"z-index-1","sd_shortcode":"[bs_container container='col'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg='5'  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg='0'  pb_lg=''  pl_lg='0'  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='z-index-1' ]","sd_shortcode_close":"[/bs_container]"} -->
				<div class="wp-block-blockstrap-blockstrap-widget-container mt-5 mb-3 pe-0 ps-0 bg-image-fixed col z-index-1"><!-- wp:blockstrap/blockstrap-widget-container {"container":"container-fluid","mb_lg":"","pr_lg":"0","pl_lg":"0","position":"sticky-top","sticky_offset_top":115,"sd_shortcode":"[bs_container container='container-fluid'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg='0'  pb_lg=''  pl_lg='0'  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position='sticky-top'  sticky_offset_top='115'  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
					<div class="wp-block-blockstrap-blockstrap-widget-container pe-0 ps-0 bg-image-fixed container-fluid sticky-top" style="top:115px"><!-- wp:geodirectory/geodir-widget-map {"height":"90vh","content":"\u003cdiv class=\u0022geodir-wgt-map bsui sdel-b50edf71\u0022 \u003e\u003cdiv class=\u0022bsui\u0022 style=\u0022overflow:hidden;height:90vh\u0022 class=\u0022wp-block-geodirectory-geodir-widget-map\u0022\u003e\u003cdiv title=\u0022Placeholder map\u0022 style=\u0022height:90vh;width:100%;background-size:cover;background-image:url(data:image/svg+xml;base64,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)\u0022 class=\u0022100 90vh\u0022\u003e\u003c/div\u003e\u003c/div\u003e\u003c/div\u003e","sd_shortcode":"[gd_map title=''  map_type='auto'  post_settings='true'  post_type=''  terms=''  tick_terms=''  tags=''  all_posts='false'  post_id=''  search_filter='false'  post_type_filter='false'  cat_filter='false'  child_collapse='false'  map_directions='false'  scrollwheel='false'  hide_zoom_control='false'  hide_street_control='false'  sticky='false'  static='false'  width='100%'  height='90vh'  maptype='ROADMAP'  zoom='0'  bg=''  mt=''  mr=''  mb=''  ml=''  pt=''  pr=''  pb=''  pl=''  border=''  rounded=''  rounded_size=''  shadow=''  css_class='' ]"} -->
						<div class="wp-block-geodirectory-geodir-widget-map"></div>
						<!-- /wp:geodirectory/geodir-widget-map --></div>
					<!-- /wp:blockstrap/blockstrap-widget-container --></div>
				<!-- /wp:blockstrap/blockstrap-widget-container --></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container -->

		<!-- wp:spacer {"height":"30px"} -->
		<div style="height:30px" aria-hidden="true" class="wp-block-spacer"></div>
		<!-- /wp:spacer -->

		<?php
		return ob_get_clean();
	}




}

GeoDir_BlockStrap::init();
