<div
	class="wpbdp-license-key-activation-ui wpbdp-main-license wpbdp-license-status-<?php echo esc_attr( $license_status ); ?>"
	id="license-box"
	data-licensing="<?php echo esc_attr( $licensing_info_attr ); ?>">
	<div class="wpbdp-license-key-license-input">
		<input type="<?php echo esc_attr( $license_status === 'valid' ? 'hidden' : 'text' ); ?>"
			id="<?php echo esc_attr( 'license-key-module-' . $item_id ); ?>" class="wpbdp-license-key-input"
			name="wpbdp_settings[<?php echo esc_attr( $setting['id'] ); ?>]" value="<?php echo esc_attr( $value ); ?>"
			<?php echo ( 'valid' === $license_status ? 'readonly="readonly"' : '' ); ?>
			placeholder="<?php esc_attr_e( 'Enter License Key here', 'business-directory-plugin' ); ?>" />
		<input type="button" value="<?php esc_attr_e( 'Authorize', 'business-directory-plugin' ); ?>"
			data-working-msg="<?php esc_attr_e( 'Please wait...', 'business-directory-plugin' ); ?>"
			class="button button-primary wpbdp-license-key-activate-btn" />
	</div>
	<div class="wpbdp-license-key-activation-status-msg wpbdp-hidden inline notice"></div>
	<?php if ( $license_status === 'valid' ) : ?>
		<p>You're using Business Directory Plugin Premium. Enjoy! 🙂
			<a href="javascript:void(0)"
				data-working-msg="<?php esc_attr_e( 'Please wait...', 'business-directory-plugin' ); ?>"
				id="wpbdp_deauthorize_link" class="wpbdp-license-key-deactivate-btn">
				<?php esc_attr_e( 'Deauthorize', 'business-directory-plugin' ); ?>
			</a>
		</p>
		<hr>
		<p>
			<?php esc_html_e( 'Missing add-ons?', 'formidable' ); ?>
			<a href="#" id="wpbdp_reauthorize_link" class="wpbdp-license-key-reauthorize-btn" data-refresh="1">
				<?php esc_html_e( 'Check now for a recent upgrade or renewal', 'formidable' ); ?>
			</a>
		</p>
	<?php endif; ?>
</div>
<style>
	#save-changes {
		display: none
	}
</style>
