var BDPConnect = window.BDPConnect || ( function( document, window, $ ) {

	/*global ajaxurl */

	/**
	 * Public functions and properties.
	 */
	const app = {

		box: null,

		/**
		 * Register connect/disconnect button event.
		 */
		init: function() {

			this.box = $( '#license-box' );

			// Toggle: activate or deactivate
			this.box.on( 'click', '.wpbdp-license-key-activate-btn', this.authorize );
			this.box.on( 'click', '.wpbdp-license-key-deactivate-btn', this.authorize );

			// Reauthorize
			this.box.on( 'click', '.wpbdp-license-key-reauthorize-btn', this.reauthorize );
		},

		/* Clear the site license cache */
		reauthorize: function() {

			var meta = app.box.data( 'licensing' ),
				msg = app.box.find( '.wpbdp-license-key-activation-status-msg' );

			$.ajax({
				type: 'POST',
				url: ajaxurl,
				dataType: 'json',
				data: {
					action: 'wpbdp_reauthorize_main_license',
					nonce: meta.nonce
				},
				success: function( res ) {
					msg.removeClass( 'status-error wpbdp-hidden' ).addClass( 'status-success' ).html( res.message ).show();

					setTimeout( () => {
						window.location.reload();
					}, 2000 );
				}
			});
			return false;
		},

		authorize: function( e ) {

			var $button, $setting, msg, activate, $field, data;
			e.preventDefault();

			$button = $( this );
			$setting = $button.parents( '.wpbdp-license-key-activation-ui' );
			msg = app.box.find( '.wpbdp-license-key-activation-status-msg' );
			activate = $button.is( '.wpbdp-license-key-activate-btn' );
			$field = $setting.find( 'input.wpbdp-license-key-input' );
			data = $setting.data( 'licensing' );

			msg.hide();
			$button.data( 'original_label', $( this ).val() );
			$button.val( $( this ).data( 'working-msg' ) );
			$button.prop( 'disabled', true );

			if ( activate ) {
				data.action = 'wpbdp_activate_main_license';
			} else {
				data.action = 'wpbdp_deactivate_main_license';
			}

			data.license_key = $field.val();

			$.post(
				ajaxurl,
				data,
				function( res ) {
					if ( res.success ) {
						msg.removeClass( 'status-error wpbdp-hidden' ).addClass( 'status-success' ).html( res.message ).show();

						setTimeout( () => {
							window.location.reload();
						}, 2000 );
					} else {
						if ( 'deactivation-failed' === res.error ) {
							return window.location.reload();
						}

						msg.removeClass( 'status-success wpbdp-hidden' ).addClass( 'status-error' ).html( res.message || res.error ).show();
					}

					$button.val( $button.data( 'original_label' ) );
					$button.prop( 'disabled', false );
				},
				'json'
			);
		}
	};

	// Provide access to public functions/properties.
	return app;

}( document, window, jQuery ) );

BDPConnect.init();
